/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl;

import com.codename1.io.Log;
import com.codename1.ui.Display;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class CodenameOneThread
extends Thread {
    private int[] stack = new int[500];
    private int stackPointer;
    private Runnable r;
    private static Class CODE = CodenameOneThread.class;
    private Hashtable exceptionStack = new Hashtable();

    public CodenameOneThread(Runnable r, String threadName) {
        super(threadName);
        this.r = r;
    }

    public boolean hasStackFrame() {
        return this.stackPointer > 0;
    }

    public void pushStack(int method) {
        this.stack[this.stackPointer] = method;
        ++this.stackPointer;
    }

    public void popStack() {
        --this.stackPointer;
    }

    public static void push(int method) {
        Thread t = Thread.currentThread();
        if (t.getClass() == CODE) {
            CodenameOneThread c = (CodenameOneThread)t;
            c.pushStack(method);
        }
    }

    public static void pop() {
        Thread t = Thread.currentThread();
        if (t.getClass() == CODE) {
            CodenameOneThread c = (CodenameOneThread)t;
            c.popStack();
        }
    }

    public void storeStackForException(Throwable t, int currentStackFrame) {
        if (!this.exceptionStack.containsKey(t)) {
            int[] s = new int[this.stackPointer + 1];
            System.arraycopy(this.stack, 0, s, 0, this.stackPointer);
            s[this.stackPointer] = currentStackFrame;
            this.exceptionStack.put(t, s);
        }
    }

    public static void storeStack(Throwable th, int currentStackFrame) {
        Thread t = Thread.currentThread();
        if (t.getClass() == CODE) {
            CodenameOneThread c = (CodenameOneThread)t;
            c.storeStackForException(th, currentStackFrame);
        }
    }

    public String getStack(Throwable t) {
        try {
            int size;
            StringBuilder b = new StringBuilder();
            int[] s = (int[])this.exceptionStack.get(t);
            if (s == null) {
                s = this.stack;
                size = this.stackPointer;
            } else {
                size = s.length;
            }
            String[] stk = new String[size];
            InputStream inp = Display.getInstance().getResourceAsStream(this.getClass(), "/methodData.dat");
            if (inp == null) {
                return t.toString();
            }
            DataInputStream di = new DataInputStream(inp);
            int totalAmount = di.readInt();
            String lastClass = "";
            for (int x = 0; x < totalAmount; ++x) {
                String current = di.readUTF();
                if (current.indexOf(46) > -1) {
                    lastClass = current;
                    continue;
                }
                for (int iter = 0; iter < size; ++iter) {
                    if (s[iter] != x + 1) continue;
                    stk[iter] = lastClass + "." + current;
                }
            }
            for (int iter = size - 1; iter >= 0; --iter) {
                b.append("at ");
                b.append(stk[iter]);
                b.append("\n");
            }
            return b.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "Failed in stack generation for " + t;
        }
    }

    public void run() {
        try {
            this.r.run();
        }
        catch (Throwable err) {
            err.printStackTrace();
            CodenameOneThread.handleException(err);
        }
    }

    public static void handleException(Throwable err) {
        if (Log.isCrashBound()) {
            Log.e(err);
            Log.sendLog();
        }
    }
}

