/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.processing;

import com.codename1.processing.Evaluator;
import com.codename1.processing.StructuredContent;
import com.codename1.util.StringUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

abstract class AbstractEvaluator
implements Evaluator {
    private String expr;

    protected AbstractEvaluator(String expr) {
        this.expr = expr;
    }

    public Object evaluate(StructuredContent element) {
        return this._evaluate(element);
    }

    public Object evaluate(List elements) {
        return this._evaluate(elements);
    }

    private Object _evaluate(Object element) {
        if (element == null) {
            return null;
        }
        int index = this.expr.indexOf("=");
        if (index != -1) {
            return this._evaluate(element, index);
        }
        index = this.expr.indexOf(">");
        if (index != -1) {
            return this._evaluate(element, index);
        }
        index = this.expr.indexOf("<");
        if (index != -1) {
            return this._evaluate(element, index);
        }
        index = this.expr.indexOf("%");
        if (index != -1) {
            return this._evaluate(element, index);
        }
        return this._evaluateSingle(element);
    }

    private Object _evaluate(Object element, int index) {
        String lvalue = this.expr.substring(0, index).trim();
        String rvalue = this.expr.substring(index + 1).trim();
        char comparator = this.expr.charAt(index);
        switch (comparator) {
            case '=': {
                return this._evaluateLeftEqualsRight(element, lvalue, rvalue);
            }
            case '>': {
                return this._evaluateLeftGreaterRight(element, lvalue, rvalue);
            }
            case '<': {
                return this._evaluateLeftLessRight(element, lvalue, rvalue);
            }
            case '%': {
                return this._evaluateLeftContainsRight(element, lvalue, rvalue);
            }
        }
        return null;
    }

    private Object _evaluateLeftLessRight(Object element, String lvalue, String rvalue) {
        if (element instanceof List) {
            return this.evaluateLeftLessRight((List)element, lvalue, rvalue);
        }
        return this.evaluateLeftLessRight((StructuredContent)element, lvalue, rvalue);
    }

    private Object _evaluateLeftGreaterRight(Object element, String lvalue, String rvalue) {
        if (element instanceof List) {
            return this.evaluateLeftGreaterRight((List)element, lvalue, rvalue);
        }
        return this.evaluateLeftGreaterRight((StructuredContent)element, lvalue, rvalue);
    }

    private Object _evaluateLeftEqualsRight(Object element, String lvalue, String rvalue) {
        if (element instanceof List) {
            return this.evaluateLeftEqualsRight((List)element, lvalue, rvalue);
        }
        return this.evaluateLeftEqualsRight((StructuredContent)element, lvalue, rvalue);
    }

    private Object _evaluateLeftContainsRight(Object element, String lvalue, String rvalue) {
        if (element instanceof List) {
            return this.evaluateLeftContainsRight((List)element, lvalue, rvalue);
        }
        return this.evaluateLeftContainsRight((StructuredContent)element, lvalue, rvalue);
    }

    private Object _evaluateSingle(Object element) {
        if (element instanceof List) {
            return this.evaluateSingle((List)element, this.expr);
        }
        return this.evaluateSingle((StructuredContent)element, this.expr);
    }

    protected boolean isNumeric(String text) {
        text = text.trim();
        int tlen = text.length();
        for (int i = 0; i < tlen; ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected String stripQuotes(String rvalue) {
        StringBuffer buf = new StringBuffer();
        int rvlen = rvalue.length();
        for (int i = 0; i < rvlen; ++i) {
            char ch = rvalue.charAt(i);
            if (ch == '\'' || ch == '\"') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    protected String[] explode(String arrayAsString) {
        if ((arrayAsString = arrayAsString.trim()).startsWith("(") && arrayAsString.endsWith(")")) {
            arrayAsString = arrayAsString.substring(1, arrayAsString.length() - 1);
        }
        Vector v = StringUtil.tokenizeString(arrayAsString, ',');
        String[] a = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            a[i] = this.stripQuotes(v.get(i).toString().trim());
        }
        return a;
    }

    protected Object evaluateSingle(StructuredContent element, String expr) {
        return null;
    }

    protected Object evaluateSingle(List elements, String expr) {
        AbstractList array = elements instanceof Vector ? new Vector() : new ArrayList();
        for (Object o : elements) {
            if (!(o instanceof StructuredContent) || (o = this.evaluateSingle((StructuredContent)o, expr)) == null) continue;
            array.add(o);
        }
        if (array.size() == 1) {
            return (StructuredContent)array.get(0);
        }
        return array;
    }

    protected Object evaluateLeftLessRight(List elements, String lvalue, String rvalue) {
        AbstractList array = elements instanceof Vector ? new Vector() : new ArrayList();
        for (Object o : elements) {
            if (!(o instanceof StructuredContent) || (o = this.evaluateLeftLessRight((StructuredContent)o, lvalue, rvalue)) == null) continue;
            array.add(o);
        }
        if (array.size() == 1) {
            return (StructuredContent)array.get(0);
        }
        return array;
    }

    protected Object evaluateLeftLessRight(StructuredContent element, String lvalue, String rvalue) {
        return null;
    }

    protected Object evaluateLeftGreaterRight(List elements, String lvalue, String rvalue) {
        AbstractList array = elements instanceof Vector ? new Vector() : new ArrayList();
        for (Object o : elements) {
            if (!(o instanceof StructuredContent) || (o = this.evaluateLeftGreaterRight((StructuredContent)o, lvalue, rvalue)) == null) continue;
            array.add(o);
        }
        if (array.size() == 1) {
            return (StructuredContent)array.get(0);
        }
        return array;
    }

    protected Object evaluateLeftGreaterRight(StructuredContent element, String lvalue, String rvalue) {
        return null;
    }

    protected Object evaluateLeftEqualsRight(List elements, String lvalue, String rvalue) {
        AbstractList array = elements instanceof Vector ? new Vector() : new ArrayList();
        for (Object o : elements) {
            if (!(o instanceof StructuredContent) || (o = this.evaluateLeftEqualsRight((StructuredContent)o, lvalue, rvalue)) == null) continue;
            array.add(o);
        }
        if (array.size() == 1) {
            return (StructuredContent)array.get(0);
        }
        return array;
    }

    protected Object evaluateLeftEqualsRight(StructuredContent element, String lvalue, String rvalue) {
        return null;
    }

    protected Object evaluateLeftContainsRight(List elements, String lvalue, String rvalue) {
        AbstractList array = elements instanceof Vector ? new Vector() : new ArrayList();
        for (Object o : elements) {
            if (!(o instanceof StructuredContent) || (o = this.evaluateLeftContainsRight((StructuredContent)o, lvalue, rvalue)) == null) continue;
            array.add(o);
        }
        if (array.size() == 1) {
            return (StructuredContent)array.get(0);
        }
        return array;
    }

    protected Object evaluateLeftContainsRight(StructuredContent element, String lvalue, String rvalue) {
        return null;
    }
}

