/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.io.Util;
import com.codename1.properties.CollectionProperty;
import com.codename1.properties.ListProperty;
import com.codename1.properties.Property;
import com.codename1.properties.PropertyBase;
import com.codename1.properties.PropertyBusinessObject;
import com.codename1.properties.PropertyChangeListener;
import com.codename1.ui.Button;
import com.codename1.ui.CheckBox;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.RadioButton;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextComponent;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.spinner.Picker;
import com.codename1.ui.table.AbstractTableModel;
import com.codename1.ui.util.EventDispatcher;
import com.codename1.ui.validation.Constraint;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiBinding {
    private boolean autoCommit = true;

    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public static void unbind(PropertyBase prop) {
        if (prop.getListeners() != null) {
            for (PropertyChangeListener l : prop.getListeners()) {
                if (!(l instanceof Binding)) continue;
                ((Binding)((Object)l)).disconnect();
                UiBinding.unbind(prop);
                return;
            }
        }
    }

    public static void unbind(PropertyBusinessObject po) {
        for (PropertyBase pb : po.getPropertyIndex()) {
            UiBinding.unbind(pb);
        }
    }

    private static ObjectConverter pickerTypeToConverter(int type) {
        switch (type) {
            case 1: 
            case 3: {
                return new DateConverter();
            }
            case 2: {
                return new IntegerConverter();
            }
            case 4: {
                return new StringConverter();
            }
        }
        throw new IllegalArgumentException("Unsupported picker type: " + type);
    }

    private ObjectConverter getPropertyConverter(PropertyBase prop) {
        Class gt = prop.getGenericType();
        if (gt == null || gt == String.class) {
            return new StringConverter();
        }
        if (gt == Integer.class) {
            return new IntegerConverter();
        }
        if (gt == Long.class) {
            return new LongConverter();
        }
        if (gt == Double.class) {
            return new DoubleConverter();
        }
        if (gt == Float.class) {
            return new FloatConverter();
        }
        if (gt == Boolean.class) {
            return new BooleanConverter();
        }
        if (gt == Date.class) {
            return new DateConverter();
        }
        throw new RuntimeException("Unsupported property converter: " + gt.getName());
    }

    GroupBinding createGroupBinding(List<Binding> allBindings) {
        return new GroupBinding(allBindings);
    }

    public Binding bind(PropertyBusinessObject obj, Container cnt) {
        ArrayList<Binding> allBindings = new ArrayList<Binding>();
        this.bind(obj, cnt, allBindings);
        return new GroupBinding(allBindings);
    }

    private void bind(PropertyBusinessObject obj, Container cnt, ArrayList<Binding> allBindings) {
        for (Component cmp : cnt) {
            PropertyBase b;
            if (cmp instanceof Container && ((Container)cmp).getLeadComponent() == null) {
                this.bind(obj, (Container)cmp, allBindings);
                continue;
            }
            String n = cmp.getName();
            if (n == null || (b = obj.getPropertyIndex().get(n)) == null) continue;
            allBindings.add(this.bind(b, cmp));
        }
    }

    public Binding bindGroup(PropertyBase prop, Object[] values, Component ... cmps) {
        ObjectConverter cnv = this.getPropertyConverter(prop);
        if (cmps[0] instanceof RadioButton) {
            RadioButton[] rb = new RadioButton[cmps.length];
            System.arraycopy(cmps, 0, rb, 0, cmps.length);
            return this.bindImpl(prop, rb, new RadioListAdapter<Object>(cnv, values));
        }
        throw new RuntimeException("Unsupported binding type: " + cmps[0].getClass().getName());
    }

    public Binding bind(PropertyBase prop, Component cmp) {
        ObjectConverter cnv = this.getPropertyConverter(prop);
        if (cmp instanceof TextArea) {
            return this.bind(prop, cmp, new TextAreaAdapter(cnv));
        }
        if (cmp instanceof TextComponent) {
            return this.bind(prop, cmp, new TextComponentAdapter(cnv));
        }
        if (cmp instanceof CheckBox) {
            return this.bind(prop, cmp, new CheckBoxRadioSelectionAdapter(cnv));
        }
        if (cmp instanceof RadioButton) {
            return this.bind(prop, cmp, new CheckBoxRadioSelectionAdapter(cnv));
        }
        if (cmp instanceof Picker) {
            return this.bind(prop, cmp, new PickerAdapter(cnv, ((Picker)cmp).getType()));
        }
        throw new RuntimeException("Unsupported binding type: " + cmp.getClass().getName());
    }

    public Binding bind(PropertyBase prop, Component cmp, ComponentAdapter adapt) {
        return this.bindImpl(prop, cmp, adapt);
    }

    public BoundTableModel createTableModel(List<? extends PropertyBusinessObject> objects, PropertyBusinessObject prototype) {
        return new BoundTableModel(objects, prototype);
    }

    public BoundTableModel createTableModel(CollectionProperty<? extends PropertyBusinessObject, ? extends Object> objects, PropertyBusinessObject prototype) {
        return new BoundTableModel(objects, prototype);
    }

    private Binding bindImpl(final PropertyBase prop, final Object cmp, final ComponentAdapter adapt) {
        adapt.assignTo(prop.get(), cmp);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class BindingImpl
        extends Binding
        implements PropertyChangeListener,
        ActionListener<ActionEvent> {
            private boolean lock;

            BindingImpl() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (this.isAutoCommit()) {
                    if (this.lock) {
                        return;
                    }
                    this.lock = true;
                    ((Property)prop).set(adapt.getFrom(cmp));
                    this.lock = false;
                }
            }

            public void propertyChanged(PropertyBase p) {
                if (this.isAutoCommit()) {
                    if (this.lock) {
                        return;
                    }
                    this.lock = true;
                    adapt.assignTo(prop.get(), cmp);
                    this.lock = false;
                }
            }

            @Override
            public void commit() {
                if (this.isAutoCommit()) {
                    throw new RuntimeException("Can't commit in autocommit mode");
                }
                ((Property)prop).set(adapt.getFrom(cmp));
            }

            @Override
            public void rollback() {
                if (this.isAutoCommit()) {
                    throw new RuntimeException("Can't rollback in autocommit mode");
                }
                adapt.assignTo(prop.get(), cmp);
            }

            @Override
            public void disconnect() {
                adapt.removeListener(cmp, this);
                prop.removeChangeListener(this);
            }
        }
        BindingImpl b = new BindingImpl();
        adapt.bindListener(cmp, b);
        prop.addChangeListener(b);
        return b;
    }

    public void bindString(Property<String, ? extends Object> prop, TextArea ta) {
        this.bind(prop, ta);
    }

    public void bindInteger(Property<Integer, ? extends Object> prop, TextArea ta) {
        this.bind(prop, ta);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoundTableModel
    extends AbstractTableModel {
        private List<? extends PropertyBusinessObject> objects;
        private CollectionProperty objectProperty;
        private PropertyBusinessObject prototype;
        private Set<String> exclude = new HashSet<String>();
        private List<String> included;
        private PropertyBase[] columnOrder;
        private Set<String> uneditable = new HashSet<String>();
        private EventDispatcher listeners = new EventDispatcher();

        public BoundTableModel(List<? extends PropertyBusinessObject> objects, PropertyBusinessObject prototype) {
            this.objects = objects;
            this.prototype = prototype;
        }

        public BoundTableModel(CollectionProperty objectProperty, PropertyBusinessObject prototype) {
            this.objectProperty = objectProperty;
            this.prototype = prototype;
        }

        public void excludeProperty(PropertyBase b) {
            this.exclude.add(b.getName());
            if (this.included == null) {
                this.included = new ArrayList<String>();
                for (PropertyBase pb : this.prototype.getPropertyIndex()) {
                    this.included.add(pb.getName());
                }
            }
            this.included.remove(b.getName());
        }

        public void setColumnOrder(PropertyBase ... columnOrder) {
            this.columnOrder = columnOrder;
        }

        public void setEditable(PropertyBase pb, boolean editable) {
            if (editable) {
                this.uneditable.remove(pb.getName());
            } else {
                this.uneditable.add(pb.getName());
            }
        }

        @Override
        public int getRowCount() {
            if (this.objects != null) {
                return this.objects.size();
            }
            return this.objectProperty.size();
        }

        public void addRow(int index, PropertyBusinessObject b) {
            if (this.objects != null) {
                this.objects.add(index, b);
            } else if (this.objectProperty instanceof ListProperty) {
                ((ListProperty)this.objectProperty).add(index, b);
            } else {
                this.objectProperty.add(b);
            }
            for (int col = 0; col < this.getColumnCount(); ++col) {
                this.listeners.fireDataChangeEvent(col, index);
            }
        }

        public void removeRow(int index) {
            if (this.objects != null) {
                this.objects.remove(index);
            } else if (this.objectProperty instanceof ListProperty) {
                ((ListProperty)this.objectProperty).remove(index);
            } else {
                Iterator i = this.objectProperty.iterator();
                for (int iter = 0; iter < index - 1; ++iter) {
                    i.next();
                }
                i.remove();
            }
            this.listeners.fireDataChangeEvent(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        @Override
        public int getColumnCount() {
            if (this.columnOrder != null) {
                return this.columnOrder.length;
            }
            return this.prototype.getPropertyIndex().getSize() - this.exclude.size();
        }

        private PropertyBase getProperty(int index) {
            if (this.included != null) {
                return this.prototype.getPropertyIndex().get(this.included.get(index));
            }
            return this.prototype.getPropertyIndex().get(index);
        }

        @Override
        public String getColumnName(int i) {
            if (this.columnOrder != null) {
                return this.columnOrder[i].getLabel();
            }
            return this.getProperty(i).getLabel();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (this.columnOrder != null && this.columnOrder.length > 0) {
                return !this.uneditable.contains(this.columnOrder[column].getName());
            }
            return !this.uneditable.contains(this.getProperty(column).getName());
        }

        private PropertyBusinessObject getRow(int row) {
            if (this.objects != null) {
                return this.objects.get(row);
            }
            if (this.objectProperty instanceof ListProperty) {
                return (PropertyBusinessObject)((ListProperty)this.objectProperty).get(row);
            }
            Iterator i = this.objectProperty.iterator();
            for (int iter = 0; iter < row - 1; ++iter) {
                i.next();
            }
            return (PropertyBusinessObject)i.next();
        }

        @Override
        public Object getValueAt(int row, int column) {
            PropertyBusinessObject pb = this.getRow(row);
            String n = this.columnOrder != null ? this.columnOrder[column].getName() : this.getProperty(column).getName();
            return pb.getPropertyIndex().get(n).get();
        }

        @Override
        public Class getCellType(int row, int column) {
            PropertyBusinessObject pb = this.getRow(row);
            String n = this.columnOrder != null ? this.columnOrder[column].getName() : this.getProperty(column).getName();
            return pb.getPropertyIndex().get(n).getGenericType();
        }

        private PropertyBase getPropertyAt(int row, int column) {
            PropertyBusinessObject pb = this.getRow(row);
            String n = this.columnOrder != null ? this.columnOrder[column].getName() : this.getProperty(column).getName();
            return pb.getPropertyIndex().get(n);
        }

        @Override
        public String[] getMultipleChoiceOptions(int row, int column) {
            return (String[])this.getPropertyAt(row, column).getClientProperty("multipleChoiceOptions");
        }

        public void setMultipleChoiceOptions(PropertyBase prop, String ... values) {
            prop.putClientProperty("multipleChoiceOptions", values);
        }

        @Override
        public Constraint getValidationConstraint(int row, int column) {
            return (Constraint)this.getPropertyAt(row, column).getClientProperty("validationConstraint");
        }

        public void setValidationConstraint(PropertyBase prop, Constraint c) {
            prop.putClientProperty("validationConstraint", c);
        }

        @Override
        public void setValueAt(int row, int column, Object o) {
            PropertyBusinessObject pb = this.getRow(row);
            String n = this.columnOrder != null ? this.columnOrder[column].getName() : this.getProperty(column).getName();
            pb.getPropertyIndex().get(n).setImpl(o);
            this.listeners.fireDataChangeEvent(column, row);
        }

        @Override
        public void addDataChangeListener(DataChangedListener d) {
            this.listeners.addListener(d);
        }

        @Override
        public void removeDataChangeListener(DataChangedListener d) {
            this.listeners.removeListener(d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupBinding
    extends Binding {
        private List<Binding> allBindings;

        public GroupBinding(List<Binding> allBindings) {
            this.allBindings = allBindings;
        }

        @Override
        public void setAutoCommit(boolean b) {
            super.setAutoCommit(b);
            for (Binding bb : this.allBindings) {
                bb.setAutoCommit(b);
            }
        }

        @Override
        public void commit() {
            for (Binding bb : this.allBindings) {
                bb.commit();
            }
        }

        @Override
        public void rollback() {
            for (Binding bb : this.allBindings) {
                bb.rollback();
            }
        }

        @Override
        public void disconnect() {
            for (Binding bb : this.allBindings) {
                bb.disconnect();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PickerAdapter<PropertyType>
    extends ComponentAdapter<PropertyType, Picker> {
        public PickerAdapter(ObjectConverter toPropertyType, int pickerType) {
            super(toPropertyType, UiBinding.pickerTypeToConverter(pickerType));
        }

        public PickerAdapter(MappingConverter toPropertyType, MappingConverter toComponentType) {
            super(toPropertyType, toComponentType);
        }

        @Override
        public void assignTo(PropertyType value, Picker cmp) {
            switch (cmp.getType()) {
                case 1: 
                case 3: {
                    cmp.setDate((Date)this.toComponentType.convert(value));
                    break;
                }
                case 2: {
                    cmp.setTime((Integer)this.toComponentType.convert(value));
                    break;
                }
                case 4: {
                    if (value instanceof Integer) {
                        cmp.setSelectedStringIndex((Integer)this.toComponentType.convert(value));
                        break;
                    }
                    cmp.setSelectedString((String)this.toComponentType.convert(value));
                }
            }
        }

        @Override
        public PropertyType getFrom(Picker cmp) {
            switch (cmp.getType()) {
                case 1: 
                case 3: {
                    return (PropertyType)this.toPropertyType.convert(cmp.getDate());
                }
                case 2: {
                    return (PropertyType)this.toPropertyType.convert(cmp.getTime());
                }
                case 4: {
                    if (this.toPropertyType instanceof IntegerConverter) {
                        return (PropertyType)new Integer(cmp.getSelectedStringIndex());
                    }
                    return (PropertyType)this.toPropertyType.convert(cmp.getSelectedString());
                }
            }
            throw new RuntimeException("Illegal state for picker binding");
        }

        @Override
        public void bindListener(Picker cmp, ActionListener<ActionEvent> l) {
            cmp.addActionListener((ActionListener)l);
        }

        @Override
        public void removeListener(Picker cmp, ActionListener<ActionEvent> l) {
            cmp.removeActionListener((ActionListener)l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RadioListAdapter<PropertyType>
    extends ComponentAdapter<PropertyType, RadioButton[]> {
        private final PropertyType[] values;

        public RadioListAdapter(ObjectConverter toPropertyType, PropertyType ... values) {
            super(toPropertyType, null);
            this.values = values;
        }

        @Override
        public void assignTo(PropertyType value, RadioButton[] cmp) {
            for (int iter = 0; iter < this.values.length; ++iter) {
                if (!this.values[iter].equals(value)) continue;
                cmp[iter].setSelected(true);
                return;
            }
        }

        @Override
        public PropertyType getFrom(RadioButton[] cmp) {
            for (int iter = 0; iter < this.values.length; ++iter) {
                if (!cmp[iter].isSelected()) continue;
                return this.values[iter];
            }
            return null;
        }

        @Override
        public void bindListener(RadioButton[] cmp, ActionListener<ActionEvent> l) {
            for (RadioButton r : cmp) {
                r.addActionListener((ActionListener)l);
            }
        }

        @Override
        public void removeListener(RadioButton[] cmp, ActionListener<ActionEvent> l) {
            for (RadioButton r : cmp) {
                r.removeActionListener((ActionListener)l);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckBoxRadioSelectionAdapter<PropertyType>
    extends ComponentAdapter<PropertyType, Button> {
        public CheckBoxRadioSelectionAdapter(ObjectConverter toPropertyType) {
            super(toPropertyType, new BooleanConverter());
        }

        @Override
        public void assignTo(PropertyType value, Button cmp) {
            if (cmp instanceof CheckBox) {
                ((CheckBox)cmp).setSelected((Boolean)this.toComponentType.convert(value));
            } else {
                ((RadioButton)cmp).setSelected((Boolean)this.toComponentType.convert(value));
            }
        }

        @Override
        public PropertyType getFrom(Button cmp) {
            return (PropertyType)this.toPropertyType.convert(cmp.isSelected());
        }

        @Override
        public void bindListener(Button cmp, ActionListener<ActionEvent> l) {
            cmp.addActionListener((ActionListener)l);
        }

        @Override
        public void removeListener(Button cmp, ActionListener<ActionEvent> l) {
            cmp.removeActionListener((ActionListener)l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextComponentAdapter<PropertyType>
    extends ComponentAdapter<PropertyType, TextComponent> {
        public TextComponentAdapter(ObjectConverter toPropertyType) {
            super(toPropertyType, new StringConverter());
        }

        public TextComponentAdapter() {
            super(new ObjectConverter(), new ObjectConverter());
        }

        @Override
        public void assignTo(PropertyType value, TextComponent cmp) {
            cmp.getField().setText((String)this.toComponentType.convert(value));
        }

        @Override
        public PropertyType getFrom(TextComponent cmp) {
            return (PropertyType)this.toPropertyType.convert(cmp.getText());
        }

        @Override
        public void bindListener(TextComponent cmp, ActionListener<ActionEvent> l) {
            cmp.getField().addActionListener((ActionListener)l);
        }

        @Override
        public void removeListener(TextComponent cmp, ActionListener<ActionEvent> l) {
            cmp.getField().removeActionListener((ActionListener)l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextAreaAdapter<PropertyType>
    extends ComponentAdapter<PropertyType, TextArea> {
        public TextAreaAdapter(ObjectConverter toPropertyType) {
            super(toPropertyType, new StringConverter());
        }

        public TextAreaAdapter() {
            super(new ObjectConverter(), new ObjectConverter());
        }

        @Override
        public void assignTo(PropertyType value, TextArea cmp) {
            cmp.setText((String)this.toComponentType.convert(value));
        }

        @Override
        public PropertyType getFrom(TextArea cmp) {
            return (PropertyType)this.toPropertyType.convert(cmp.getText());
        }

        @Override
        public void bindListener(TextArea cmp, ActionListener<ActionEvent> l) {
            cmp.addActionListener((ActionListener)l);
        }

        @Override
        public void removeListener(TextArea cmp, ActionListener<ActionEvent> l) {
            cmp.removeActionListener((ActionListener)l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ComponentAdapter<PropertyType, ComponentType> {
        protected final ObjectConverter toPropertyType;
        protected final ObjectConverter toComponentType;

        public ComponentAdapter(ObjectConverter toPropertyType, ObjectConverter toComponentType) {
            this.toPropertyType = toPropertyType;
            this.toComponentType = toComponentType;
        }

        public abstract void assignTo(PropertyType var1, ComponentType var2);

        public abstract PropertyType getFrom(ComponentType var1);

        public abstract void bindListener(ComponentType var1, ActionListener<ActionEvent> var2);

        public abstract void removeListener(ComponentType var1, ActionListener<ActionEvent> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappingConverter
    extends ObjectConverter {
        private Map<Object, Object> m;

        public MappingConverter(Map<Object, Object> m) {
            this.m = m;
        }

        @Override
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            return this.m.get(source);
        }
    }

    public static class BooleanConverter
    extends ObjectConverter {
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof Boolean) {
                return (boolean)((Boolean)source);
            }
            if (source instanceof String) {
                String s = ((String)source).toLowerCase();
                return s.indexOf("true") > 0 || s.indexOf("yes") > 0 || s.indexOf("1") > 0;
            }
            return Util.toIntValue(source) > 0;
        }
    }

    public static class DoubleConverter
    extends ObjectConverter {
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            return Util.toDoubleValue(source);
        }
    }

    public static class FloatConverter
    extends ObjectConverter {
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            return Float.valueOf(Util.toFloatValue(source));
        }
    }

    public static class LongConverter
    extends ObjectConverter {
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            return Util.toLongValue(source);
        }
    }

    public static class DateConverter
    extends ObjectConverter {
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof Date) {
                return (Date)source;
            }
            return new Date(Util.toLongValue(source));
        }
    }

    public static class IntegerConverter
    extends ObjectConverter {
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            return Util.toIntValue(source);
        }
    }

    public static class StringConverter
    extends ObjectConverter {
        public Object convert(Object source) {
            if (source == null) {
                return null;
            }
            return source.toString();
        }
    }

    public static class ObjectConverter {
        public Object convert(Object source) {
            return source;
        }
    }

    public abstract class Binding {
        private boolean autoCommit;

        public Binding() {
            this.autoCommit = UiBinding.this.autoCommit;
        }

        public void setAutoCommit(boolean b) {
            this.autoCommit = b;
        }

        public boolean isAutoCommit() {
            return this.autoCommit;
        }

        public abstract void commit();

        public abstract void rollback();

        public abstract void disconnect();
    }
}

