/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.AutoCompleteTextField;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.TextComponent;
import com.codename1.ui.TextField;
import com.codename1.ui.animations.ComponentAnimation;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.list.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteTextComponent
extends TextComponent {
    private final AutoCompleteTextField field;
    private Container animationLayer;
    private Boolean focusAnimation;
    private static int animationSpeed = 100;

    @Override
    public TextField getField() {
        return this.field;
    }

    public AutoCompleteTextComponent(ListModel<String> listModel, final AutoCompleteFilter customFilter) {
        this.field = new AutoCompleteTextField(listModel){

            void paintHint(Graphics g) {
                if (AutoCompleteTextComponent.this.isFocusAnimation()) {
                    if (!this.hasFocus()) {
                        super.paintHint(g);
                    }
                } else {
                    super.paintHint(g);
                }
            }

            void focusGainedInternal() {
                super.focusGainedInternal();
                if (this.isInitialized() && AutoCompleteTextComponent.this.isFocusAnimation()) {
                    AutoCompleteTextComponent.this.getLabel().setFocus(true);
                    if (!AutoCompleteTextComponent.this.getLabel().isVisible()) {
                        final Label text = new Label(this.getHint(), "TextHint");
                        this.setHint("");
                        final Label placeholder = new Label();
                        Component.setSameSize(placeholder, AutoCompleteTextComponent.this.field);
                        AutoCompleteTextComponent.this.animationLayer.add((Object)"North", text);
                        AutoCompleteTextComponent.this.animationLayer.add((Object)"Center", placeholder);
                        text.setX(this.getX());
                        text.setY(this.getY());
                        text.setWidth(this.getWidth());
                        text.setHeight(this.getHeight());
                        ComponentAnimation anim = ComponentAnimation.compoundAnimation(AutoCompleteTextComponent.this.animationLayer.createAnimateLayout(animationSpeed), text.createStyleAnimation("FloatingHint", animationSpeed));
                        this.getAnimationManager().addAnimation(anim, new Runnable(){

                            public void run() {
                                Component.setSameSize(AutoCompleteTextComponent.this.field);
                                text.remove();
                                placeholder.remove();
                                AutoCompleteTextComponent.this.getLabel().setVisible(true);
                            }
                        });
                    }
                }
            }

            void focusLostInternal() {
                super.focusLostInternal();
                if (this.isInitialized() && AutoCompleteTextComponent.this.isFocusAnimation()) {
                    AutoCompleteTextComponent.this.getLabel().setFocus(false);
                    if (this.getText().length() == 0 && AutoCompleteTextComponent.this.getLabel().isVisible()) {
                        final Label text = new Label(AutoCompleteTextComponent.this.getLabel().getText(), AutoCompleteTextComponent.this.getLabel().getUIID());
                        final Label placeholder = new Label();
                        Component.setSameSize(placeholder, AutoCompleteTextComponent.this.getLabel());
                        AutoCompleteTextComponent.this.animationLayer.add((Object)"North", placeholder);
                        AutoCompleteTextComponent.this.animationLayer.add((Object)"Center", text);
                        text.setX(AutoCompleteTextComponent.this.getLabel().getX());
                        text.setY(AutoCompleteTextComponent.this.getLabel().getY());
                        text.setWidth(AutoCompleteTextComponent.this.getLabel().getWidth());
                        text.setHeight(AutoCompleteTextComponent.this.getLabel().getHeight());
                        String hintLabelUIID = "TextHint";
                        if (this.getHintLabel() != null) {
                            hintLabelUIID = this.getHintLabel().getUIID();
                        }
                        ComponentAnimation anim = ComponentAnimation.compoundAnimation(AutoCompleteTextComponent.this.animationLayer.createAnimateLayout(animationSpeed), text.createStyleAnimation(hintLabelUIID, animationSpeed));
                        this.getAnimationManager().addAnimation(anim, new Runnable(){

                            public void run() {
                                this.setHint(AutoCompleteTextComponent.this.getLabel().getText());
                                AutoCompleteTextComponent.this.getLabel().setVisible(false);
                                Component.setSameSize(AutoCompleteTextComponent.this.getLabel());
                                text.remove();
                                placeholder.remove();
                            }
                        });
                    }
                }
            }

            protected boolean filter(String text) {
                return customFilter.filter(text);
            }
        };
        this.initInput();
    }

    @Override
    void constructUI() {
        if (this.getComponentCount() == 0) {
            if (this.isOnTopMode() && this.isFocusAnimation()) {
                this.getLabel().setUIID("FloatingHint");
                this.setLayout(new LayeredLayout());
                Container tfContainer = BorderLayout.center(this.field).add((Object)"North", this.getLabel()).add((Object)"South", LayeredLayout.encloseIn(this.getErrorMessage(), this.getDescriptionMessage()));
                this.add(tfContainer);
                Label errorMessageFiller = new Label();
                Component.setSameSize(errorMessageFiller, this.getErrorMessage());
                this.animationLayer = BorderLayout.south(errorMessageFiller);
                this.add(this.animationLayer);
                if (this.field.getText() == null || this.field.getText().length() == 0) {
                    this.field.setHint(this.getLabel().getText());
                    this.getLabel().setVisible(false);
                }
            } else {
                super.constructUI();
            }
        }
    }

    @Override
    public Component getEditor() {
        return this.field;
    }

    @Override
    void refreshForGuiBuilder() {
        if (guiBuilderMode.booleanValue()) {
            if (this.animationLayer != null) {
                this.animationLayer.remove();
            }
            super.refreshForGuiBuilder();
        }
    }

    @Override
    public boolean isFocusAnimation() {
        if (this.focusAnimation != null) {
            return this.focusAnimation;
        }
        return this.getUIManager().isThemeConstant("textComponentAnimBool", false);
    }

    @Override
    public AutoCompleteTextComponent focusAnimation(boolean focusAnimation) {
        this.focusAnimation = focusAnimation;
        this.refreshForGuiBuilder();
        return this;
    }

    @Override
    public AutoCompleteTextComponent text(String text) {
        this.field.setText(text);
        this.refreshForGuiBuilder();
        return this;
    }

    @Override
    public AutoCompleteTextComponent onTopMode(boolean onTopMode) {
        return (AutoCompleteTextComponent)super.onTopMode(onTopMode);
    }

    @Override
    public AutoCompleteTextComponent descriptionMessage(String descriptionMessage) {
        super.descriptionMessage(descriptionMessage);
        return this;
    }

    @Override
    public AutoCompleteTextComponent errorMessage(String errorMessage) {
        super.errorMessage(errorMessage);
        return this;
    }

    @Override
    public AutoCompleteTextComponent label(String text) {
        super.label(text);
        return this;
    }

    @Override
    public AutoCompleteTextComponent labelAndHint(String text) {
        super.label(text);
        this.hint(text);
        return this;
    }

    @Override
    public AutoCompleteTextComponent hint(String hint) {
        this.field.setHint(hint);
        this.refreshForGuiBuilder();
        return this;
    }

    @Override
    public AutoCompleteTextComponent hint(Image hint) {
        this.field.setHintIcon(hint);
        this.refreshForGuiBuilder();
        return this;
    }

    @Override
    public AutoCompleteTextComponent multiline(boolean multiline) {
        this.field.setSingleLineTextArea(!multiline);
        this.refreshForGuiBuilder();
        return this;
    }

    @Override
    public AutoCompleteTextComponent columns(int columns) {
        this.field.setColumns(columns);
        this.refreshForGuiBuilder();
        return this;
    }

    @Override
    public AutoCompleteTextComponent rows(int rows) {
        this.field.setRows(rows);
        this.refreshForGuiBuilder();
        return this;
    }

    @Override
    public AutoCompleteTextComponent constraint(int constraint) {
        this.field.setConstraint(constraint);
        return this;
    }

    public AutoCompleteTextField getAutoCompleteField() {
        return this.field;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"text", "label", "hint", "multiline", "columns", "rows", "constraint"};
    }

    @Override
    public Class[] getPropertyTypes() {
        return new Class[]{String.class, String.class, String.class, Boolean.class, Integer.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getPropertyTypeNames() {
        return new String[]{"String", "String", "String", "Boolean", "Integer", "Integer", "Integer"};
    }

    @Override
    public Object getPropertyValue(String name) {
        if (name.equals("text")) {
            return this.field.getText();
        }
        if (name.equals("hint")) {
            return this.field.getHint();
        }
        if (name.equals("multiline")) {
            return !this.field.isSingleLineTextArea();
        }
        if (name.equals("columns")) {
            return this.field.getColumns();
        }
        if (name.equals("rows")) {
            return this.field.getRows();
        }
        if (name.equals("constraint")) {
            return this.field.getConstraint();
        }
        return super.getPropertyValue(name);
    }

    @Override
    public String setPropertyValue(String name, Object value) {
        if (name.equals("text")) {
            this.text((String)value);
            return null;
        }
        if (name.equals("hint")) {
            this.hint((String)value);
            return null;
        }
        if (name.equals("multiline")) {
            this.field.setSingleLineTextArea((Boolean)value == false);
            return null;
        }
        if (name.equals("columns")) {
            this.field.setColumns((Integer)value);
            return null;
        }
        if (name.equals("rows")) {
            this.field.setRows((Integer)value);
            return null;
        }
        if (name.equals("constraint")) {
            this.field.setConstraint((Integer)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    public static interface AutoCompleteFilter {
        public boolean filter(String var1);
    }
}

