/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.compat.java.util.Objects;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.Log;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import com.codename1.ui.CN;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.util.FailureCallback;
import com.codename1.util.StringUtil;
import com.codename1.util.SuccessCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class URLImage
extends EncodedImage {
    private static final Map<String, URLImage> pendingToStorage = new HashMap<String, URLImage>();
    private static final Map<String, URLImage> pendingToFile = new HashMap<String, URLImage>();
    public static final int FLAG_RESIZE_FAIL = 3;
    public static final ImageAdapter RESIZE_FAIL = new ImageAdapter(){

        public EncodedImage adaptImage(EncodedImage downloadedImage, EncodedImage placeholderImage) {
            if (downloadedImage.getWidth() != placeholderImage.getWidth() || downloadedImage.getHeight() != placeholderImage.getHeight()) {
                throw new RuntimeException("Invalid image size");
            }
            return downloadedImage;
        }

        public boolean isAsyncAdapter() {
            return false;
        }
    };
    public static final int FLAG_RESIZE_SCALE = 1;
    public static final ImageAdapter RESIZE_SCALE = new ImageAdapter(){

        public EncodedImage adaptImage(EncodedImage downloadedImage, EncodedImage placeholderImage) {
            if (downloadedImage.getWidth() != placeholderImage.getWidth() || downloadedImage.getHeight() != placeholderImage.getHeight()) {
                return downloadedImage.scaledEncoded(placeholderImage.getWidth(), placeholderImage.getHeight());
            }
            return downloadedImage;
        }

        public boolean isAsyncAdapter() {
            return false;
        }
    };
    public static final int FLAG_RESIZE_SCALE_TO_FILL = 2;
    public static final ImageAdapter RESIZE_SCALE_TO_FILL = new ScaleToFill();
    private final EncodedImage placeholder;
    private final String url;
    private final ImageAdapter adapter;
    private final String storageFile;
    private final String fileSystemFile;
    private boolean fetching;
    private byte[] imageData;
    private boolean repaintImage;
    private static final String IMAGE_SUFFIX = "ImageURLTMP";
    private boolean locked;
    private static ErrorCallback exceptionHandler;

    public static ErrorCallback getExceptionHandler() {
        return exceptionHandler;
    }

    public static void setExceptionHandler(ErrorCallback aExceptionHandler) {
        exceptionHandler = aExceptionHandler;
    }

    private URLImage(EncodedImage placeholder, String url, ImageAdapter adapter, String storageFile, String fileSystemFile) {
        super(placeholder.getWidth(), placeholder.getHeight());
        this.placeholder = placeholder;
        this.url = url;
        this.adapter = adapter;
        this.storageFile = storageFile;
        this.fileSystemFile = fileSystemFile;
    }

    public static ImageAdapter createMaskAdapter(Image imageMask) {
        final Object mask = imageMask.createMask();
        return new ScaleToFill(){

            Image postProcess(Image i) {
                return i.applyMask(mask);
            }
        };
    }

    public static ImageAdapter createMaskAdapter(final Object mask) {
        return new ScaleToFill(){

            Image postProcess(Image i) {
                return i.applyMask(mask);
            }
        };
    }

    private void loadImageFromStorageURLToStorage(final String targetKey) {
        Display.getInstance().scheduleBackgroundTask(new Runnable(){

            public void run() {
                try {
                    if (!Objects.equals(URLImage.this.url, targetKey)) {
                        InputStream input = Storage.getInstance().createInputStream(URLImage.this.url);
                        OutputStream output = Storage.getInstance().createOutputStream(targetKey);
                        Util.copy(input, output);
                    }
                    CN.callSerially(new Runnable(){

                        public void run() {
                            try {
                                Image value = Image.createImage(Storage.getInstance().createInputStream(targetKey));
                                DownloadCompleted onComplete = new DownloadCompleted();
                                onComplete.setSourceImage(value);
                                onComplete.actionPerformed(new ActionEvent(value));
                            }
                            catch (Exception ex) {
                                if (exceptionHandler != null) {
                                    exceptionHandler.onError(URLImage.this, ex);
                                }
                                throw new RuntimeException(ex.toString());
                            }
                        }
                    });
                }
                catch (Exception t) {
                    if (exceptionHandler != null) {
                        exceptionHandler.onError(URLImage.this, t);
                    }
                    throw new RuntimeException(t.toString());
                }
            }
        });
    }

    private void loadImageFromFileURLToStorage(final String targetKey) {
        Display.getInstance().scheduleBackgroundTask(new Runnable(){

            public void run() {
                try {
                    InputStream input = FileSystemStorage.getInstance().openInputStream(URLImage.this.url);
                    OutputStream output = Storage.getInstance().createOutputStream(targetKey);
                    Util.copy(input, output);
                    CN.callSerially(new Runnable(){

                        public void run() {
                            try {
                                Image value = Image.createImage(Storage.getInstance().createInputStream(targetKey));
                                DownloadCompleted onComplete = new DownloadCompleted();
                                onComplete.setSourceImage(value);
                                onComplete.actionPerformed(new ActionEvent(value));
                            }
                            catch (Exception ex) {
                                if (exceptionHandler != null) {
                                    exceptionHandler.onError(URLImage.this, ex);
                                }
                                throw new RuntimeException(ex.toString());
                            }
                        }
                    });
                }
                catch (Exception t) {
                    if (exceptionHandler != null) {
                        exceptionHandler.onError(URLImage.this, t);
                    }
                    throw new RuntimeException(t.toString());
                }
            }
        });
    }

    private void loadImageFromStorageURLToFileSystem(final String targetFile) {
        Display.getInstance().scheduleBackgroundTask(new Runnable(){

            public void run() {
                try {
                    InputStream input = Storage.getInstance().createInputStream(URLImage.this.url);
                    OutputStream output = FileSystemStorage.getInstance().openOutputStream(targetFile);
                    Util.copy(input, output);
                    CN.callSerially(new Runnable(){

                        public void run() {
                            try {
                                Image value = Image.createImage(FileSystemStorage.getInstance().openInputStream(targetFile));
                                DownloadCompleted onComplete = new DownloadCompleted();
                                onComplete.setSourceImage(value);
                                onComplete.actionPerformed(new ActionEvent(value));
                            }
                            catch (Exception ex) {
                                if (exceptionHandler != null) {
                                    exceptionHandler.onError(URLImage.this, ex);
                                }
                                throw new RuntimeException(ex.toString());
                            }
                        }
                    });
                }
                catch (Exception t) {
                    if (exceptionHandler != null) {
                        exceptionHandler.onError(URLImage.this, t);
                    }
                    throw new RuntimeException(t.toString());
                }
            }
        });
    }

    private void loadImageFromFileURLToFileSystem(final String targetFile) {
        Display.getInstance().scheduleBackgroundTask(new Runnable(){

            public void run() {
                try {
                    InputStream input = FileSystemStorage.getInstance().openInputStream(URLImage.this.url);
                    OutputStream output = FileSystemStorage.getInstance().openOutputStream(targetFile);
                    Util.copy(input, output);
                    CN.callSerially(new Runnable(){

                        public void run() {
                            try {
                                Image value = Image.createImage(FileSystemStorage.getInstance().openInputStream(targetFile));
                                DownloadCompleted onComplete = new DownloadCompleted();
                                onComplete.setSourceImage(value);
                                onComplete.actionPerformed(new ActionEvent(value));
                            }
                            catch (Exception ex) {
                                if (exceptionHandler != null) {
                                    exceptionHandler.onError(URLImage.this, ex);
                                }
                                throw new RuntimeException(ex.toString());
                            }
                        }
                    });
                }
                catch (Exception t) {
                    if (exceptionHandler != null) {
                        exceptionHandler.onError(URLImage.this, t);
                    }
                    throw new RuntimeException(t.toString());
                }
            }
        });
    }

    public void fetch() {
        if (this.fetching || this.imageData != null) {
            return;
        }
        this.fetching = true;
        try {
            this.locked = super.isLocked();
            if (this.storageFile != null) {
                if (Storage.getInstance().exists(this.storageFile)) {
                    super.unlock();
                    this.imageData = new byte[Storage.getInstance().entrySize(this.storageFile)];
                    InputStream is = Storage.getInstance().createInputStream(this.storageFile);
                    Util.readFully(is, this.imageData);
                    this.resetCache();
                    this.fetching = false;
                    this.repaintImage = true;
                    this.fireChangedEvent();
                    return;
                }
                if (this.adapter != null) {
                    if (this.url.startsWith("http://") || this.url.startsWith("https://")) {
                        Util.downloadImageToStorage(this.url, this.storageFile + IMAGE_SUFFIX, new SuccessCallback<Image>(){

                            @Override
                            public void onSucess(Image value) {
                                DownloadCompleted onComplete = new DownloadCompleted();
                                onComplete.setSourceImage(value);
                                onComplete.actionPerformed(new ActionEvent(value));
                            }
                        });
                    } else if (this.url.startsWith("file:/")) {
                        this.loadImageFromFileURLToStorage(this.storageFile + IMAGE_SUFFIX);
                    } else {
                        this.loadImageFromStorageURLToStorage(this.storageFile + IMAGE_SUFFIX);
                    }
                } else if (this.url.startsWith("http://") || this.url.startsWith("https://")) {
                    Util.downloadImageToStorage(this.url, this.storageFile, new SuccessCallback<Image>(){

                        @Override
                        public void onSucess(Image value) {
                            DownloadCompleted onComplete = new DownloadCompleted();
                            onComplete.setSourceImage(value);
                            onComplete.actionPerformed(new ActionEvent(value));
                        }
                    });
                } else if (this.url.startsWith("file:/")) {
                    this.loadImageFromFileURLToStorage(this.storageFile);
                } else {
                    this.loadImageFromStorageURLToStorage(this.storageFile);
                }
            } else {
                if (FileSystemStorage.getInstance().exists(this.fileSystemFile)) {
                    super.unlock();
                    this.imageData = new byte[(int)FileSystemStorage.getInstance().getLength(this.fileSystemFile)];
                    InputStream is = FileSystemStorage.getInstance().openInputStream(this.fileSystemFile);
                    Util.readFully(is, this.imageData);
                    this.resetCache();
                    this.fetching = false;
                    this.repaintImage = true;
                    this.fireChangedEvent();
                    return;
                }
                if (this.adapter != null) {
                    if (this.url.startsWith("http://") || this.url.startsWith("https://")) {
                        Util.downloadImageToFileSystem(this.url, this.fileSystemFile + IMAGE_SUFFIX, new SuccessCallback<Image>(){

                            @Override
                            public void onSucess(Image value) {
                                DownloadCompleted onComplete = new DownloadCompleted();
                                onComplete.setSourceImage(value);
                                onComplete.actionPerformed(new ActionEvent(value));
                            }
                        });
                    } else if (this.url.startsWith("file:/")) {
                        this.loadImageFromFileURLToFileSystem(this.fileSystemFile + IMAGE_SUFFIX);
                    } else {
                        this.loadImageFromStorageURLToFileSystem(this.fileSystemFile + IMAGE_SUFFIX);
                    }
                } else if (this.url.startsWith("http://") || this.url.startsWith("https://")) {
                    Util.downloadImageToFileSystem(this.url, this.fileSystemFile, new SuccessCallback<Image>(){

                        @Override
                        public void onSucess(Image value) {
                            DownloadCompleted onComplete = new DownloadCompleted();
                            onComplete.setSourceImage(value);
                            onComplete.actionPerformed(new ActionEvent(value));
                        }
                    });
                } else if (this.url.startsWith("file:")) {
                    this.loadImageFromFileURLToFileSystem(this.fileSystemFile);
                } else {
                    this.loadImageFromStorageURLToFileSystem(this.fileSystemFile);
                }
            }
        }
        catch (IOException ioErr) {
            if (exceptionHandler != null) {
                exceptionHandler.onError(this, ioErr);
            }
            throw new RuntimeException(ioErr.toString());
        }
    }

    protected Image getInternal() {
        if (this.imageData == null) {
            this.fetch();
            return this.placeholder;
        }
        return super.getInternal();
    }

    public byte[] getImageData() {
        if (this.imageData != null) {
            return this.imageData;
        }
        return this.placeholder.getImageData();
    }

    public boolean animate() {
        if (this.repaintImage) {
            this.repaintImage = false;
            if (this.locked) {
                super.lock();
                this.locked = false;
            }
            return true;
        }
        return false;
    }

    public void lock() {
    }

    public void unlock() {
    }

    public boolean isAnimation() {
        return this.repaintImage || this.imageData == null;
    }

    public static URLImage createToStorage(EncodedImage placeholder, String storageFile, String url) {
        return URLImage.createToStorage(placeholder, storageFile, url, RESIZE_SCALE_TO_FILL);
    }

    public static URLImage createToStorage(EncodedImage placeholder, String storageFile, String url, ImageAdapter adapter) {
        URLImage out = pendingToStorage.get(storageFile);
        if (out != null) {
            return out;
        }
        out = new URLImage(placeholder, url.intern(), adapter, storageFile.intern(), null);
        pendingToStorage.put(storageFile, out);
        return out;
    }

    public static URLImage createToFileSystem(EncodedImage placeholder, String file, String url, ImageAdapter adapter) {
        URLImage out = pendingToFile.get(file);
        if (out != null) {
            return out;
        }
        out = new URLImage(placeholder, url.intern(), adapter, null, file.intern());
        pendingToFile.put(file, out);
        return out;
    }

    public static Image createCachedImage(String imageName, String url, Image placeholder, int resizeRule) {
        if (Display.getInstance().supportsNativeImageCache()) {
            CachedImage im = new CachedImage(placeholder, url, resizeRule);
            im.setImageName(imageName);
            return im;
        }
        ImageAdapter adapter = null;
        switch (resizeRule) {
            case 3: {
                adapter = RESIZE_FAIL;
                break;
            }
            case 1: {
                adapter = RESIZE_SCALE;
                break;
            }
            case 2: {
                adapter = RESIZE_SCALE_TO_FILL;
                break;
            }
            default: {
                adapter = RESIZE_SCALE_TO_FILL;
            }
        }
        FileSystemStorage fs = FileSystemStorage.getInstance();
        if (fs.hasCachesDir()) {
            String name = "cn1_image_cache[" + url + "]";
            name = StringUtil.replaceAll(name, "/", "_");
            name = StringUtil.replaceAll(name, "\\", "_");
            name = StringUtil.replaceAll(name, "%", "_");
            name = StringUtil.replaceAll(name, "?", "_");
            name = StringUtil.replaceAll(name, "*", "_");
            name = StringUtil.replaceAll(name, ":", "_");
            name = StringUtil.replaceAll(name, "=", "_");
            String filePath = fs.getCachesDir() + fs.getFileSystemSeparator() + name;
            URLImage im = URLImage.createToFileSystem(EncodedImage.createFromImage(placeholder, false), filePath, url, adapter);
            im.setImageName(imageName);
            return im;
        }
        URLImage im = URLImage.createToStorage(EncodedImage.createFromImage(placeholder, false), "cn1_image_cache[" + url + "@" + placeholder.getWidth() + "x" + placeholder.getHeight(), url, adapter);
        im.setImageName(imageName);
        return im;
    }

    private static class CachedImage
    extends Image {
        boolean fetching;
        int resizeRule;
        Object image;
        Image placeholderImage;
        String url;
        boolean repaintImage;

        public boolean animate() {
            if (this.repaintImage) {
                this.repaintImage = false;
                return true;
            }
            return false;
        }

        public boolean isAnimation() {
            return this.repaintImage || this.image == null;
        }

        public Object getImage() {
            if (this.image != null) {
                return this.image;
            }
            return super.getImage();
        }

        public CachedImage(Image placeholder, String url, int resize) {
            super(placeholder.getImage());
            this.url = url;
            this.resizeRule = resize;
            this.placeholderImage = placeholder;
            Util.downloadImageToCache(url, new SuccessCallback<Image>(){

                @Override
                public void onSucess(Image downloadedImage) {
                    CachedImage.this.fetching = false;
                    switch (CachedImage.this.resizeRule) {
                        case 3: {
                            if (downloadedImage.getWidth() == CachedImage.this.placeholderImage.getWidth() && downloadedImage.getHeight() == CachedImage.this.placeholderImage.getHeight()) break;
                            throw new RuntimeException("Invalid image size");
                        }
                        case 1: {
                            downloadedImage = downloadedImage.scaled(CachedImage.this.placeholderImage.getWidth(), CachedImage.this.placeholderImage.getHeight());
                            break;
                        }
                        case 2: {
                            if (downloadedImage.getWidth() == CachedImage.this.placeholderImage.getWidth() && downloadedImage.getHeight() == CachedImage.this.placeholderImage.getHeight()) break;
                            Image tmp = downloadedImage.scaledLargerRatio(CachedImage.this.placeholderImage.getWidth(), CachedImage.this.placeholderImage.getHeight());
                            Image i = Image.createImage(CachedImage.this.placeholderImage.getWidth(), CachedImage.this.placeholderImage.getHeight(), 0);
                            Graphics g = i.getGraphics();
                            g.setAntiAliased(true);
                            if (tmp.getWidth() > CachedImage.this.placeholderImage.getWidth()) {
                                int diff = tmp.getWidth() - CachedImage.this.placeholderImage.getWidth();
                                int x = diff / 2;
                                g.drawImage(tmp, -x, 0);
                                tmp = i;
                            } else if (tmp.getHeight() > CachedImage.this.placeholderImage.getHeight()) {
                                int diff = tmp.getHeight() - CachedImage.this.placeholderImage.getHeight();
                                int y = diff / 2;
                                g.drawImage(tmp, 0, -y);
                                tmp = i;
                            }
                            downloadedImage = tmp;
                        }
                    }
                    CachedImage.this.image = downloadedImage.getImage();
                    CachedImage.this.repaintImage = true;
                    CachedImage.this.fireChangedEvent();
                }
            }, new FailureCallback<Image>(){

                @Override
                public void onError(Object sender, Throwable err, int errorCode, String errorMessage) {
                    throw new RuntimeException("Failed to download image " + CachedImage.this.url + " from cache");
                }
            });
        }
    }

    public static interface ImageAdapter {
        public EncodedImage adaptImage(EncodedImage var1, EncodedImage var2);

        public boolean isAsyncAdapter();
    }

    class DownloadCompleted
    implements ActionListener,
    Runnable {
        private EncodedImage adapt;
        private EncodedImage adaptedIns;
        private Image sourceImage;

        DownloadCompleted() {
        }

        public void run() {
            this.adaptedIns = URLImage.this.adapter.adaptImage(this.adapt, URLImage.this.placeholder);
        }

        public void actionPerformed(ActionEvent evt) {
            if (URLImage.this.adapter != null) {
                try {
                    OutputStream o;
                    EncodedImage adapted;
                    EncodedImage img;
                    if (this.sourceImage == null) {
                        InputStream is;
                        byte[] d;
                        if (URLImage.this.storageFile != null) {
                            d = new byte[Storage.getInstance().entrySize(URLImage.this.storageFile + URLImage.IMAGE_SUFFIX)];
                            is = Storage.getInstance().createInputStream(URLImage.this.storageFile + URLImage.IMAGE_SUFFIX);
                        } else {
                            d = new byte[(int)FileSystemStorage.getInstance().getLength(URLImage.this.fileSystemFile + URLImage.IMAGE_SUFFIX)];
                            is = FileSystemStorage.getInstance().openInputStream(URLImage.this.fileSystemFile + URLImage.IMAGE_SUFFIX);
                        }
                        Util.readFully(is, d);
                        img = EncodedImage.create(d);
                    } else {
                        img = EncodedImage.createFromImage(this.sourceImage, false);
                    }
                    if (URLImage.this.adapter.isAsyncAdapter()) {
                        this.adapt = img;
                        Display.getInstance().invokeAndBlock(this);
                        adapted = this.adaptedIns;
                        this.adaptedIns = null;
                        this.adapt = null;
                    } else {
                        try {
                            adapted = URLImage.this.adapter.adaptImage(img, URLImage.this.placeholder);
                        }
                        catch (Exception err) {
                            if (exceptionHandler != null) {
                                exceptionHandler.onError(URLImage.this, err);
                            } else {
                                Log.p("Failed to load image from URL: " + URLImage.this.url);
                                Log.e(err);
                            }
                            return;
                        }
                    }
                    if (URLImage.this.storageFile != null) {
                        o = Storage.getInstance().createOutputStream(URLImage.this.storageFile);
                        o.write(adapted.getImageData());
                        o.close();
                        Storage.getInstance().deleteStorageFile(URLImage.this.storageFile + URLImage.IMAGE_SUFFIX);
                        pendingToStorage.remove(URLImage.this.storageFile);
                    } else if (URLImage.this.fileSystemFile != null) {
                        o = FileSystemStorage.getInstance().openOutputStream(URLImage.this.fileSystemFile);
                        o.write(adapted.getImageData());
                        o.close();
                        FileSystemStorage.getInstance().delete(URLImage.this.fileSystemFile + URLImage.IMAGE_SUFFIX);
                        pendingToFile.remove(URLImage.this.fileSystemFile);
                    }
                }
                catch (IOException ex) {
                    if (exceptionHandler != null) {
                        exceptionHandler.onError(URLImage.this, ex);
                    } else {
                        Log.e(ex);
                    }
                    return;
                }
            }
            URLImage.this.fetching = false;
            URLImage.this.fetch();
        }

        void setSourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
        }
    }

    public static interface ErrorCallback {
        public void onError(URLImage var1, Exception var2);
    }

    static class ScaleToFill
    implements ImageAdapter {
        ScaleToFill() {
        }

        public EncodedImage adaptImage(EncodedImage downloadedImage, EncodedImage placeholderImage) {
            if (downloadedImage.getWidth() != placeholderImage.getWidth() || downloadedImage.getHeight() != placeholderImage.getHeight()) {
                Image tmp = downloadedImage.getInternal().scaledLargerRatio(placeholderImage.getWidth(), placeholderImage.getHeight());
                Image i = Image.createImage(placeholderImage.getWidth(), placeholderImage.getHeight(), 0);
                Graphics g = i.getGraphics();
                if (tmp.getWidth() > placeholderImage.getWidth()) {
                    int diff = tmp.getWidth() - placeholderImage.getWidth();
                    int x = diff / 2;
                    g.drawImage(tmp, -x, 0);
                    tmp = i;
                } else if (tmp.getHeight() > placeholderImage.getHeight()) {
                    int diff = tmp.getHeight() - placeholderImage.getHeight();
                    int y = diff / 2;
                    g.drawImage(tmp, 0, -y);
                    tmp = i;
                }
                tmp = this.postProcess(tmp);
                return EncodedImage.createFromImage(tmp, false);
            }
            return downloadedImage;
        }

        Image postProcess(Image i) {
            return i;
        }

        public boolean isAsyncAdapter() {
            return false;
        }
    }
}

