/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.Component;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.List;
import com.codename1.ui.list.DefaultListCellRenderer;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.Effects;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpinnerRenderer<T>
extends DefaultListCellRenderer<T> {
    private Map<Character, Image>[] imageCache;
    private static final int PERSPECTIVES = 9;
    private static final int FRONT_ANGLE = 4;
    private static final float[] TOP_SCALE = new float[]{0.5f, 0.5f, 0.8f, 0.95f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] BOTTOM_SCALE = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.95f, 0.8f, 0.5f, 0.5f};
    private static final float[] VERTICAL_SHRINK = new float[]{0.5f, 0.5f, 0.8f, 0.9f, 1.0f, 0.9f, 0.8f, 0.5f, 0.5f};
    int perspective;
    static boolean iOS7Mode;

    public SpinnerRenderer() {
        super(false);
    }

    @Override
    public Component getCellRendererComponent(Component list, Object model, T value, int index, boolean isSelected) {
        if (iOS7Mode) {
            this.perspective = -1;
            int idx = ((List)list).getCurrentSelected();
            if (idx == index) {
                this.perspective = 4;
            } else {
                int directDistance;
                int count = ((List)list).getModel().getSize();
                int indirect = index > idx ? count - index + idx : count - idx + index;
                if (indirect < (directDistance = Math.abs(idx - index))) {
                    if (indirect < 4) {
                        this.perspective = index < idx ? indirect : 5 + indirect;
                    }
                } else if (directDistance < 4) {
                    this.perspective = index < idx ? directDistance : 5 + directDistance;
                }
            }
        }
        return super.getCellRendererComponent(list, model, value, index, isSelected);
    }

    @Override
    public void paint(Graphics g) {
        if (!iOS7Mode || this.perspective == 4) {
            super.paint(g);
        } else {
            if (!this.isInClippingRegion(g)) {
                return;
            }
            Style s = this.getStyle();
            this.drawStringPerspectivePosition(g, this.getText(), this.getX() + s.getPaddingLeftNoRTL(), this.getY() + s.getPaddingTop());
        }
    }

    private int drawCharPerspectivePosition(Graphics g, char c, int x, int y) {
        Character chr;
        Image i;
        if (this.imageCache == null) {
            this.imageCache = new HashMap[9];
            for (int iter = 0; iter < 9; ++iter) {
                if (iter == 4) continue;
                this.imageCache[iter] = new HashMap<Character, Image>();
            }
        }
        if ((i = this.imageCache[this.perspective].get(chr = new Character(c))) == null) {
            Font f = this.getStyle().getFont();
            int w = f.charWidth(c);
            int h = f.getHeight();
            i = ImageFactory.createImage(this, w, h, 0);
            g = i.getGraphics();
            UIManager.getInstance().getLookAndFeel().setFG(g, this);
            g.drawChar(c, 0, 0);
            i = Effects.verticalPerspective(i, TOP_SCALE[this.perspective], BOTTOM_SCALE[this.perspective], VERTICAL_SHRINK[this.perspective]);
            this.imageCache[this.perspective].put(chr, i);
        }
        g.drawImage(i, x, y);
        return i.getWidth();
    }

    private void drawStringPerspectivePosition(Graphics g, String s, int x, int y) {
        if (this.perspective < 0 || this.perspective >= 9) {
            return;
        }
        int l = s.length();
        int position = 0;
        for (int iter = 0; iter < l; ++iter) {
            char c = s.charAt(iter);
            position += this.drawCharPerspectivePosition(g, c, x + position, y);
            position -= 4;
        }
    }
}

