/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

import com.codename1.util.BigInteger;
import com.codename1.util.TBigDecimal;

public class BigDecimal {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    TBigDecimal peer;

    public static BigDecimal getInstance(BigInteger value, int scale) {
        return new BigDecimal(value.shiftLeft(scale), scale);
    }

    public BigDecimal(BigInteger bigInt, int scale) {
        this.peer = new TBigDecimal(bigInt.peer, scale);
    }

    private BigDecimal(BigDecimal limBigDec) {
        this.peer = new TBigDecimal(limBigDec.toString());
    }

    private BigDecimal(TBigDecimal peer) {
        this.peer = peer;
    }

    public BigDecimal adjustScale(int newScale) {
        return new BigDecimal(this.peer.setScale(newScale));
    }

    public BigDecimal add(BigDecimal b) {
        return new BigDecimal(this.peer.add(b.peer));
    }

    public BigDecimal add(BigInteger b) {
        return new BigDecimal(this.peer.add(new TBigDecimal(b.peer, 0)));
    }

    public BigDecimal negate() {
        return new BigDecimal(this.peer.negate());
    }

    public BigDecimal subtract(BigDecimal b) {
        return new BigDecimal(this.peer.subtract(b.peer));
    }

    public BigDecimal subtract(BigInteger b) {
        return new BigDecimal(this.peer.subtract(new TBigDecimal(b.peer, 0)));
    }

    public BigDecimal multiply(BigDecimal b) {
        return new BigDecimal(this.peer.multiply(b.peer));
    }

    public BigDecimal multiply(BigInteger b) {
        return new BigDecimal(this.peer.multiply(new TBigDecimal(b.peer, 0)));
    }

    public BigDecimal divide(BigDecimal b) {
        return new BigDecimal(this.peer.divide(b.peer));
    }

    public BigDecimal divide(BigInteger b) {
        return new BigDecimal(this.peer.divide(new TBigDecimal(b.peer, 0)));
    }

    public BigDecimal shiftLeft(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    public int compareTo(BigDecimal val) {
        return this.peer.compareTo(val.peer);
    }

    public int compareTo(BigInteger val) {
        return this.peer.compareTo(new TBigDecimal(val.peer, 0));
    }

    public BigInteger floor() {
        BigInteger out = new BigInteger(this.peer.toBigInteger());
        if (this.peer.signum() < 0) {
            return out.subtract(new BigInteger("1", 0));
        }
        return out;
    }

    public BigInteger round() {
        BigInteger out = new BigInteger(this.peer.toBigInteger());
        BigDecimal outD = new BigDecimal(out, 0);
        BigInteger next = this.peer.signum() < 0 ? out.subtract(BigInteger.ONE) : out.add(BigInteger.ONE);
        BigDecimal nextD = new BigDecimal(next, 0);
        BigDecimal diffThis = new BigDecimal(outD.peer.abs().subtract(this.peer.abs()).abs());
        BigDecimal diffNext = new BigDecimal(outD.peer.abs().subtract(nextD.peer.abs()).abs());
        return diffThis.compareTo(diffNext) > 0 ? out : next;
    }

    public int intValue() {
        return this.floor().intValue();
    }

    public long longValue() {
        return this.floor().longValue();
    }

    public int getScale() {
        return this.peer.scale();
    }

    public String toString() {
        return this.peer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BigDecimal)) {
            return false;
        }
        BigDecimal other = (BigDecimal)o;
        return this.peer.equals(other.peer);
    }

    public int hashCode() {
        return this.peer.hashCode();
    }
}

