package net.informaticalibera.tests.goldeneditor;

import static com.codename1.ui.CN.*;
import com.codename1.ui.*;
import com.codename1.ui.layouts.*;
import com.codename1.io.*;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.plaf.*;
import com.codename1.ui.util.Resources;

/**
 * This file was generated by <a href="https://www.codenameone.com/">Codename
 * One</a> for the purpose of building native mobile applications using Java.
 */
public class GoldenEditor {

    private Form current;
    private Resources theme;

    private long pressedTime = -1;

    public void init(Object context) {
        // use two network threads instead of one
        updateNetworkThreadCount(2);

        DeviceUtilities.loadCSS("theme");

        // Enable Toolbar on all Forms by default
        Toolbar.setGlobalToolbar(true);

        // Pro only feature
        Log.bindCrashProtection(true);

        addNetworkErrorListener(err -> {
            // prevent the event from propagating
            err.consume();
            if (err.getError() != null) {
                Log.e(err.getError());
            }
            Log.sendLogAsync();
            Dialog.show("Connection Error", "There was a networking error in the connection to " + err.getConnectionRequest().getUrl(), "OK", null);
        });
    }

    public void start() {
        if (current != null) {
            current.show();
            return;
        }

        Form hi = new Form("Golden Editor", new BorderLayout());
        hi.getToolbar().hideToolbar();
        hi.getContentPane().setSafeArea(true);
        hi.setFormBottomPaddingEditingMode(true);
        TextArea textArea = new TextArea();
        if (!Preferences.get("isFirstRun", true)) {
            textArea.setText(Preferences.get("TextArea", ""));
        } else {
            textArea.setText("Ciao, sono Golden Editor\nQui puoi scrivere le tue note\n\nPer condividerle, premi lo schermo per almeno tre secondi");
            Preferences.set("isFirstRun", false);
        }
        textArea.setHint("Golden Editor - Premi 3 sec per condividere");
        textArea.getHintLabel().setUIID("TextAreaHint");
        hi.add(BorderLayout.CENTER, textArea);

        textArea.addDataChangedListener((int type, int index) -> {
            Preferences.set("TextArea", textArea.getText());
        });

        textArea.addPointerPressedListener(l -> {
            Log.p("Pointer pressed listener");
            pressedTime = System.currentTimeMillis();
        });

        textArea.addPointerReleasedListener(l -> {
            Log.p("Pointer released listener");
            if (pressedTime > -1 && System.currentTimeMillis() - pressedTime > 3000) {
                Log.p("Sharing text");
                textArea.stopEditing();
                Display.getInstance().share(textArea.getText(), null, "text/plain");
            }
        });

        hi.show();
    }

    public void stop() {
        current = getCurrentForm();
        if (current instanceof Dialog) {
            ((Dialog) current).dispose();
            current = getCurrentForm();
        }
    }

    public void destroy() {
    }

}
